/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.sas;

import com.ibm.hwmca.base.rsf.handlers.BaseRsfDataTransfer;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.sas.ChangePasswordRequestBody;
import com.ibm.hwmca.base.rsf.sas.CredentialCompletionStatus;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.sas.EnrollmentRequestBody;
import com.ibm.hwmca.base.rsf.sas.UpdateSystemRequestBody;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rcs.sas.SasTransactionException;
import com.ibm.hwmca.fw.rcs.sas.SasXmlException;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rcs.sas.SystemAuthentication;
import com.ibm.hwmca.fw.rcs.sas.SystemAuthenticationException;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class SystemAuthenticationHandler
implements BaseRsfDataTransfer,
BaseRsfHandlersErrorIds {
    private static final String TRACE_MASKT = "XRSFSAST";
    private static final String TRACE_MASKF = "XRSFSASF";
    private static final String TRACE_MASKD = "XRSFSASD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "SysAuth-DataXfer");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static FrameworkLogAttributes infoLogDisplayError = new FrameworkLogAttributes(false, false, true, true, true, true, false, 0);
    private BaseRsfResultDetails details = new BaseRsfResultDetails();
    private int rc = 99;
    private static final int MAX_AUTH_RETRIES = 3;
    private static final int retryWait = 1000;
    private static final int longerRetryWait = 60000;

    public SystemAuthenticationHandler() {
        Trace.trace(TRACE_MASKT, "<> SystemAuthenticationHandler constructor");
    }

    public int transmit(TcpConnection connection, RsfRequestBody content, BaseRsfRequestImpl request) throws IOException {
        Trace.trace(TRACE_MASKD, "SystemAuthenticationHandler.transmit: request = " + content);
        this.rc = 0;
        CredentialResult credResult = new CredentialResult();
        this.details.getRsfResultDetails().putAttribute("Credential Result", credResult);
        Object credentials = null;
        int retryCount = 0;
        String lastRc = null;
        String reqType = "";
        while (retryCount <= 3) {
            try {
                RsfRequestBody data;
                ++retryCount;
                if (content instanceof EnrollmentRequestBody) {
                    reqType = "Enrollment";
                    EnrollmentRequestBody data2 = (EnrollmentRequestBody)content;
                    credResult.setCredentials(SystemAuthentication.enrollSystem(connection, data2.getSystemIdentifier(), data2.getClientLocation(), data2.getCompanyIdentifier(), data2.getLicenseAcceptance(), data2.getRegisterUsers(), data2.getXSeriesEnrollment(), data2.getZSeriesEnrollment(), data2.getPSeriesEnrollment()));
                    credResult.setStatus(CredentialCompletionStatus.SUCCESS);
                    Trace.trace(TRACE_MASKT, "<- SystemAuthenticationHandler.transmit, enroll success");
                    return 0;
                }
                SysInfo sendingCredentials = null;
                try {
                    sendingCredentials = CredentialUtils.getLocalCredentials();
                }
                catch (Exception e) {
                    HException exc = new HException(e);
                    this.logInternalErrorAndContinue("SystemAuthenticationHandler: Exception getting local HMC credentials", exc);
                    credResult.setStatus(CredentialCompletionStatus.INTERNAL_CODE_ERROR);
                    return 99;
                }
                if (sendingCredentials == null) {
                    HException exc = new HException("SystemAuthenticationHandler found null local credentials");
                    this.logInternalErrorAndContinue("SystemAuthenticationHandler: No local HMC credentials", exc);
                    credResult.setStatus(CredentialCompletionStatus.INTERNAL_CODE_ERROR);
                    return 99;
                }
                if (content instanceof UpdateSystemRequestBody) {
                    reqType = "Update system";
                    data = (UpdateSystemRequestBody)content;
                    SystemAuthentication.updateSystem(connection, sendingCredentials, ((UpdateSystemRequestBody)data).getCredentials(), ((UpdateSystemRequestBody)data).getSystemIdentifier(), ((UpdateSystemRequestBody)data).getClientLocation(), ((UpdateSystemRequestBody)data).getCompanyIdentifier(), ((UpdateSystemRequestBody)data).getLicenseAcceptance(), ((UpdateSystemRequestBody)data).getRegisterUsers(), ((UpdateSystemRequestBody)data).getXSeriesEnrollment(), ((UpdateSystemRequestBody)data).getZSeriesEnrollment(), ((UpdateSystemRequestBody)data).getPSeriesEnrollment());
                    credResult.setStatus(CredentialCompletionStatus.SUCCESS);
                    Trace.trace(TRACE_MASKT, "<- SystemAuthenticationHandler.transmit, update success");
                    return 0;
                }
                if (content instanceof ChangePasswordRequestBody) {
                    reqType = "Change password";
                    data = (ChangePasswordRequestBody)content;
                    credResult.setCredentials(SystemAuthentication.updatePassword(connection, sendingCredentials, ((ChangePasswordRequestBody)data).getCredentials()));
                    credResult.setStatus(CredentialCompletionStatus.SUCCESS);
                    Trace.trace(TRACE_MASKT, "<- SystemAuthenticationHandler.transmit, change password");
                    return 0;
                }
                this.logInternalErrorAndContinue("SystemAuthenticationHandler: invalid request body type: " + content.getClass(), null);
                credResult.setStatus(CredentialCompletionStatus.INTERNAL_CODE_ERROR);
                return 99;
            }
            catch (SasTransactionException e) {
                lastRc = e.getMessage();
                String message = "SystemAuthenticationHandler: rc from " + reqType + " request=" + lastRc;
                if (lastRc.equals("2000") || lastRc.equals("2100")) {
                    if (retryCount <= 3) {
                        this.retryWait(retryCount, message);
                        continue;
                    }
                } else if (lastRc.equals("3000")) {
                    if (retryCount <= 3) {
                        this.retryLongWait(retryCount, message);
                        continue;
                    }
                } else if (lastRc.equals("5000")) {
                    String msg = message + "(request format failure).\nOne possible cause of this is no configured customer information";
                    this.logErrorAndContinue(msg, null, (short)28481);
                    this.details.setErrLogMsg(msg);
                    credResult.setStatus(CredentialCompletionStatus.REQUEST_FAILURE);
                    this.details.setReasonCode(20);
                    return 999;
                }
                this.logErrorAndContinue(message, e, (short)28481);
                credResult.setStatus(CredentialCompletionStatus.SERVER_FAILURE);
                this.details.setReasonCode(20);
                return 99;
            }
            catch (SasXmlException e) {
                String msg = "SystemAuthenticationHandler: SasXmlException processing " + reqType + " request";
                this.logErrorAndContinue(msg, e, (short)28481);
                this.details.setReasonCode(20);
                credResult.setStatus(CredentialCompletionStatus.SERVER_FAILURE);
                throw new IOException("SAS Server error for " + reqType + ": xml error");
            }
            catch (SystemAuthenticationException e) {
                String msg = "SystemAuthenticationHandler: SystemAuthenticationException processing " + reqType + " request";
                this.logErrorAndContinue(msg, e, (short)28481);
                this.details.setReasonCode(20);
                credResult.setStatus(CredentialCompletionStatus.SERVER_FAILURE);
                throw new IOException("SAS Server error for " + reqType + ": System authentication exception");
            }
            catch (IOException e) {
                String msg = "SystemAuthenticationHandler: I/O Exception processing " + reqType + "request";
                this.logErrorAndContinue(msg, e, (short)28481);
                credResult.setStatus(CredentialCompletionStatus.COMMUNICATION_FAILURE);
                throw e;
            }
            catch (Exception e) {
                this.logInternalErrorAndContinue("SystemAuthenticationHandler: transmit exception:", e);
                credResult.setStatus(CredentialCompletionStatus.INTERNAL_CODE_ERROR);
                return 99;
            }
        }
        Trace.trace(TRACE_MASKT, "<- SystemAuthenticationHandler.transmit, rc = " + this.rc);
        return this.rc;
    }

    private void retryWait(int retryCount, String message) {
        this.logInfo(message + ". Tries=" + retryCount + ". Will wait " + 1000 + " milliseconds.", null, (short)28481);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {}
    }

    private void retryLongWait(int retryCount, String message) {
        this.logInfo(message + ". Tries=" + retryCount + ". Will wait " + 60000 + " milliseconds.", null, (short)28481);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {}
    }

    public void requestCancelling() {
    }

    public BaseRsfResultDetails getResult() {
        return this.details;
    }

    private void logErrorAndExit(String errorMsg, Throwable t, short errorId, int resultError) {
        FrameworkLog errLog;
        this.details.setReasonCode(resultError);
        this.rc = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private void logInternalError(String errorMsg, Throwable t) {
        this.logErrorAndExit(errorMsg, t, (short)28671, 7);
    }

    private void logInternalErrorAndContinue(String errorMsg, Throwable t) {
        this.logErrorAndContinue(errorMsg, t, (short)28671);
    }

    private void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }
}

